#include "mode1/erdiagram/PrimaryKey.h"
#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/DrawERDlg.h"
#include "mode1/erdiagram/Canvas.h"

PrimaryKey::PrimaryKey(QRectF rect, int count, QString text, QGraphicsItem * parent) : QGraphicsTextItem(text, parent)
{
	this->setPos(rect.x()+5, rect.y()+(16*count)+2);
	this->setFlag(QGraphicsItem::ItemIsSelectable);
	Canvas* canvas = DrawERDlg::getInstance()->GetCanvas();
	connect(this, SIGNAL(lostFocus2(PrimaryKey *)), canvas, SLOT(editorLostFocus2(PrimaryKey *)));
}

PrimaryKey::~PrimaryKey()
{
}

void PrimaryKey::mousePressEvent ( QGraphicsSceneMouseEvent * event )
{
	this->scene()->clearSelection();
	setTextInteractionFlags(Qt::TextEditorInteraction);
    QGraphicsSceneMouseEvent *mouseEvent =
        new QGraphicsSceneMouseEvent(QEvent::GraphicsSceneMousePress);
    mouseEvent->setAccepted(true);
    mouseEvent->setPos(event->pos());
    mouseEvent->setScenePos(event->scenePos());
    mouseEvent->setScreenPos(event->screenPos());
    mouseEvent->setButtonDownPos(Qt::LeftButton,
        event->buttonDownPos(Qt::LeftButton));
    mouseEvent->setButtonDownScreenPos(Qt::LeftButton,
        event->buttonDownScreenPos(Qt::LeftButton));
    mouseEvent->setButtonDownScenePos(Qt::LeftButton,
        event->buttonDownScenePos(Qt::LeftButton));
    mouseEvent->setWidget(event->widget());
	
    QGraphicsTextItem::mousePressEvent(mouseEvent);
	
    delete mouseEvent;
}

void PrimaryKey::keyPressEvent ( QKeyEvent * event )
{
	if( event->key() == Qt::Key_Enter || event->key() == Qt::Key_Return ){
		
		this->setSelected(false);
		
		this->clearFocus();		
	}

	else if( event->modifiers() == Qt::ControlModifier && event->key() == Qt::Key_Equal){
		((PrimaryKeysRect*)(this->parentItem()))->InsertPrimaryKey();
	}

	else if( event->modifiers() == Qt::ControlModifier && event->key() == Qt::Key_Minus){
		
		PrimaryKeysRect* primaryKeyRect = (PrimaryKeysRect*)(this->parentItem());
		Table* table = (Table*)(primaryKeyRect->parentItem());
		
		if( ((PrimaryKeysRect*)(this->parentItem()))->GetPrimaryKeys().count() > 1 ){
			((PrimaryKeysRect*)(this->parentItem()))->DeletePrimaryKey(this);
		}

		table->ReSize();
	}
	else{
		QGraphicsTextItem::keyPressEvent(event);
	}
}

void PrimaryKey::focusOutEvent(QFocusEvent *event)
{
    this->setTextInteractionFlags(Qt::NoTextInteraction);
	
	Table* table = (Table*)(((PrimaryKey*)(this->parentItem()))->parentItem());
	
	
	QRectF tableRect = table->boundingRect();
	QRectF textRect = this->boundingRect();
	
	if( tableRect.width() < this->boundingRect().width()+14 ){
		table->ReSize();
	}
	
	emit lostFocus2(this);
	
	QGraphicsTextItem::focusOutEvent(event);
}
